/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CorrectionEngine;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.NameMatcher;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.swt.graphics.Image;

public class SuppressWarningsSubProcessor {
    private static final String ADD_SUPPRESSWARNINGS_ID = "org.eclipse.jdt.ui.correction.addSuppressWarnings";
    static /* synthetic */ Class class$0;

    public static final boolean hasSuppressWarningsProposal(int problemId) {
        return CorrectionEngine.getWarningToken((int)problemId) != null;
    }

    public static void addSuppressWarningsProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        BodyDeclaration target;
        if (problem.isError()) {
            return;
        }
        if ("disabled".equals(context.getCompilationUnit().getJavaProject().getOption("org.eclipse.jdt.core.compiler.problem.suppressWarnings", true))) {
            return;
        }
        String warningToken = CorrectionEngine.getWarningToken((int)problem.getProblemId());
        if (warningToken == null) {
            return;
        }
        Iterator iter = proposals.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof SuppressWarningsProposal) || !warningToken.equals(((SuppressWarningsProposal)element).getWarningToken())) continue;
            return;
        }
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (node == null) {
            return;
        }
        if (node.getLocationInParent() == VariableDeclarationFragment.NAME_PROPERTY) {
            ASTNode parent = node.getParent();
            if (parent.getLocationInParent() == VariableDeclarationStatement.FRAGMENTS_PROPERTY) {
                SuppressWarningsSubProcessor.addSuppressWarningsProposal(context.getCompilationUnit(), parent.getParent(), warningToken, -2, proposals);
                return;
            }
        } else {
            if (node.getLocationInParent() == SingleVariableDeclaration.NAME_PROPERTY) {
                SuppressWarningsSubProcessor.addSuppressWarningsProposal(context.getCompilationUnit(), node.getParent(), warningToken, -2, proposals);
                return;
            }
            if (node.getLocationInParent() == VariableDeclarationFragment.INITIALIZER_PROPERTY && (node = ASTResolving.findParentBodyDeclaration(node)) instanceof FieldDeclaration) {
                node = node.getParent();
            }
        }
        if ((target = ASTResolving.findParentBodyDeclaration(node)) instanceof Initializer) {
            target = ASTResolving.findParentBodyDeclaration(target.getParent());
        }
        if (target == null) {
            ASTNode importStatement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.ImportDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((importStatement = ASTNodes.getParent(node, clazz)) != null && !context.getASTRoot().types().isEmpty()) {
                target = (ASTNode)context.getASTRoot().types().get(0);
            }
        }
        if (target != null) {
            SuppressWarningsSubProcessor.addSuppressWarningsProposal(context.getCompilationUnit(), (ASTNode)target, warningToken, -3, proposals);
        }
    }

    private static String getFirstFragmentName(List fragments) {
        if (fragments.size() > 0) {
            return ((VariableDeclarationFragment)fragments.get(0)).getName().getIdentifier();
        }
        return new String();
    }

    private static void addSuppressWarningsProposal(ICompilationUnit cu, ASTNode node, String warningToken, int relevance, Collection proposals) {
        String name;
        ChildListPropertyDescriptor property = null;
        switch (node.getNodeType()) {
            case 44: {
                property = SingleVariableDeclaration.MODIFIERS2_PROPERTY;
                name = ((SingleVariableDeclaration)node).getName().getIdentifier();
                break;
            }
            case 60: {
                property = VariableDeclarationStatement.MODIFIERS2_PROPERTY;
                name = SuppressWarningsSubProcessor.getFirstFragmentName(((VariableDeclarationStatement)node).fragments());
                break;
            }
            case 55: {
                property = TypeDeclaration.MODIFIERS2_PROPERTY;
                name = ((TypeDeclaration)node).getName().getIdentifier();
                break;
            }
            case 81: {
                property = AnnotationTypeDeclaration.MODIFIERS2_PROPERTY;
                name = ((AnnotationTypeDeclaration)node).getName().getIdentifier();
                break;
            }
            case 71: {
                property = EnumDeclaration.MODIFIERS2_PROPERTY;
                name = ((EnumDeclaration)node).getName().getIdentifier();
                break;
            }
            case 23: {
                property = FieldDeclaration.MODIFIERS2_PROPERTY;
                name = SuppressWarningsSubProcessor.getFirstFragmentName(((FieldDeclaration)node).fragments());
                break;
            }
            case 28: {
                property = Initializer.MODIFIERS2_PROPERTY;
                name = CorrectionMessages.SuppressWarningsSubProcessor_suppress_warnings_initializer_label;
                break;
            }
            case 31: {
                property = MethodDeclaration.MODIFIERS2_PROPERTY;
                name = String.valueOf(((MethodDeclaration)node).getName().getIdentifier()) + "()";
                break;
            }
            case 82: {
                property = AnnotationTypeMemberDeclaration.MODIFIERS2_PROPERTY;
                name = String.valueOf(((AnnotationTypeMemberDeclaration)node).getName().getIdentifier()) + "()";
                break;
            }
            case 72: {
                property = EnumConstantDeclaration.MODIFIERS2_PROPERTY;
                name = ((EnumConstantDeclaration)node).getName().getIdentifier();
                break;
            }
            default: {
                JavaPlugin.logErrorMessage("SuppressWarning quick fix: wrong node kind: " + node.getNodeType());
                return;
            }
        }
        String label = Messages.format(CorrectionMessages.SuppressWarningsSubProcessor_suppress_warnings_label, new String[]{warningToken, BasicElementLabels.getJavaElementName(name)});
        SuppressWarningsProposal proposal = new SuppressWarningsProposal(warningToken, label, cu, node, property, relevance);
        proposals.add(proposal);
    }

    public static void addUnknownSuppressWarningProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ASTNode coveringNode = context.getCoveringNode();
        if (!(coveringNode instanceof StringLiteral)) {
            return;
        }
        AST ast = coveringNode.getAST();
        StringLiteral literal = (StringLiteral)coveringNode;
        String literalValue = literal.getLiteralValue();
        String[] allWarningTokens = CorrectionEngine.getAllWarningTokens();
        int i = 0;
        while (i < allWarningTokens.length) {
            String curr = allWarningTokens[i];
            if (NameMatcher.isSimilarName(literalValue, curr)) {
                StringLiteral newLiteral = ast.newStringLiteral();
                newLiteral.setLiteralValue(curr);
                ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                rewrite.replace((ASTNode)literal, (ASTNode)newLiteral, null);
                String label = Messages.format(CorrectionMessages.SuppressWarningsSubProcessor_fix_suppress_token_label, new String[]{curr});
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 5, image);
                proposals.add(proposal);
            }
            ++i;
        }
    }

    public static void addRemoveUnusedSuppressWarningProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ASTNode coveringNode = problem.getCoveringNode(context.getASTRoot());
        if (!(coveringNode instanceof StringLiteral)) {
            return;
        }
        StringLiteral literal = (StringLiteral)coveringNode;
        if (coveringNode.getParent() instanceof MemberValuePair) {
            coveringNode = coveringNode.getParent();
        }
        ASTNode parent = coveringNode.getParent();
        ASTRewrite rewrite = ASTRewrite.create((AST)coveringNode.getAST());
        if (parent instanceof SingleMemberAnnotation) {
            rewrite.remove(parent, null);
        } else if (parent instanceof NormalAnnotation) {
            NormalAnnotation annot = (NormalAnnotation)parent;
            if (annot.values().size() == 1) {
                rewrite.remove((ASTNode)annot, null);
            } else {
                rewrite.remove(coveringNode, null);
            }
        } else if (parent instanceof ArrayInitializer) {
            rewrite.remove(coveringNode, null);
        } else {
            return;
        }
        String label = Messages.format(CorrectionMessages.SuppressWarningsSubProcessor_remove_annotation_label, literal.getLiteralValue());
        Image image = JavaPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 5, image);
        proposals.add(proposal);
    }

    private static class SuppressWarningsProposal
    extends ASTRewriteCorrectionProposal {
        private final String fWarningToken;
        private final ASTNode fNode;
        private final ChildListPropertyDescriptor fProperty;

        public SuppressWarningsProposal(String warningToken, String label, ICompilationUnit cu, ASTNode node, ChildListPropertyDescriptor property, int relevance) {
            super(label, cu, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.jdoc_tag_obj.gif"));
            this.fWarningToken = warningToken;
            this.fNode = node;
            this.fProperty = property;
            this.setCommandId(SuppressWarningsSubProcessor.ADD_SUPPRESSWARNINGS_ID);
        }

        public String getWarningToken() {
            return this.fWarningToken;
        }

        protected ASTRewrite getRewrite() throws CoreException {
            NormalAnnotation annotation;
            Expression value;
            AST ast = this.fNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            StringLiteral newStringLiteral = ast.newStringLiteral();
            newStringLiteral.setLiteralValue(this.fWarningToken);
            Annotation existing = SuppressWarningsProposal.findExistingAnnotation((List)this.fNode.getStructuralProperty((StructuralPropertyDescriptor)this.fProperty));
            if (existing == null) {
                ListRewrite listRewrite = rewrite.getListRewrite(this.fNode, this.fProperty);
                SingleMemberAnnotation newAnnot = ast.newSingleMemberAnnotation();
                String importString = this.createImportRewrite((CompilationUnit)this.fNode.getRoot()).addImport("java.lang.SuppressWarnings");
                newAnnot.setTypeName(ast.newName(importString));
                newAnnot.setValue((Expression)newStringLiteral);
                listRewrite.insertFirst((ASTNode)newAnnot, null);
            } else if (existing instanceof SingleMemberAnnotation) {
                SingleMemberAnnotation annotation2 = (SingleMemberAnnotation)existing;
                Expression value2 = annotation2.getValue();
                if (!SuppressWarningsProposal.addSuppressArgument(rewrite, value2, newStringLiteral)) {
                    rewrite.set((ASTNode)existing, (StructuralPropertyDescriptor)SingleMemberAnnotation.VALUE_PROPERTY, (Object)newStringLiteral, null);
                }
            } else if (existing instanceof NormalAnnotation && !SuppressWarningsProposal.addSuppressArgument(rewrite, value = SuppressWarningsProposal.findValue((annotation = (NormalAnnotation)existing).values()), newStringLiteral)) {
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)annotation, NormalAnnotation.VALUES_PROPERTY);
                MemberValuePair pair = ast.newMemberValuePair();
                pair.setName(ast.newSimpleName("value"));
                pair.setValue((Expression)newStringLiteral);
                listRewrite.insertFirst((ASTNode)pair, null);
            }
            return rewrite;
        }

        private static boolean addSuppressArgument(ASTRewrite rewrite, Expression value, StringLiteral newStringLiteral) {
            if (value instanceof ArrayInitializer) {
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)value, ArrayInitializer.EXPRESSIONS_PROPERTY);
                listRewrite.insertLast((ASTNode)newStringLiteral, null);
            } else if (value instanceof StringLiteral) {
                ArrayInitializer newArr = rewrite.getAST().newArrayInitializer();
                newArr.expressions().add(rewrite.createMoveTarget((ASTNode)value));
                newArr.expressions().add(newStringLiteral);
                rewrite.replace((ASTNode)value, (ASTNode)newArr, null);
            } else {
                return false;
            }
            return true;
        }

        private static Expression findValue(List keyValues) {
            int i = 0;
            int len = keyValues.size();
            while (i < len) {
                MemberValuePair curr = (MemberValuePair)keyValues.get(i);
                if ("value".equals(curr.getName().getIdentifier())) {
                    return curr.getValue();
                }
                ++i;
            }
            return null;
        }

        private static Annotation findExistingAnnotation(List modifiers) {
            int i = 0;
            int len = modifiers.size();
            while (i < len) {
                String fullyQualifiedName;
                Annotation annotation;
                ITypeBinding typeBinding;
                Object curr = modifiers.get(i);
                if ((curr instanceof NormalAnnotation || curr instanceof SingleMemberAnnotation) && ((typeBinding = (annotation = (Annotation)curr).resolveTypeBinding()) != null ? "java.lang.SuppressWarnings".equals(typeBinding.getQualifiedName()) : "SuppressWarnings".equals(fullyQualifiedName = annotation.getTypeName().getFullyQualifiedName()) || "java.lang.SuppressWarnings".equals(fullyQualifiedName))) {
                    return annotation;
                }
                ++i;
            }
            return null;
        }
    }
}

