/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.search.DeprecatedFilter;
import org.eclipse.jdt.internal.ui.search.ErasureMatchFilter;
import org.eclipse.jdt.internal.ui.search.ImportFilter;
import org.eclipse.jdt.internal.ui.search.InexactMatchFilter;
import org.eclipse.jdt.internal.ui.search.JavaElementMatch;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavadocFilter;
import org.eclipse.jdt.internal.ui.search.NonDeprecatedFilter;
import org.eclipse.jdt.internal.ui.search.NonPublicFilter;
import org.eclipse.jdt.internal.ui.search.NonStaticFilter;
import org.eclipse.jdt.internal.ui.search.PolymorphicFilter;
import org.eclipse.jdt.internal.ui.search.PotentialFilter;
import org.eclipse.jdt.internal.ui.search.ReadFilter;
import org.eclipse.jdt.internal.ui.search.StaticFilter;
import org.eclipse.jdt.internal.ui.search.WriteFilter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchFilter;

abstract class JavaMatchFilter
extends MatchFilter {
    private static final String SETTINGS_LAST_USED_FILTERS = "filters_last_used";
    private static final JavaMatchFilter POTENTIAL_FILTER = new PotentialFilter();
    private static final JavaMatchFilter IMPORT_FILTER = new ImportFilter();
    private static final JavaMatchFilter JAVADOC_FILTER = new JavadocFilter();
    private static final JavaMatchFilter READ_FILTER = new ReadFilter();
    private static final JavaMatchFilter WRITE_FILTER = new WriteFilter();
    private static final JavaMatchFilter POLYMORPHIC_FILTER = new PolymorphicFilter();
    private static final JavaMatchFilter INEXACT_FILTER = new InexactMatchFilter();
    private static final JavaMatchFilter ERASURE_FILTER = new ErasureMatchFilter();
    private static final JavaMatchFilter NON_PUBLIC_FILTER = new NonPublicFilter();
    private static final JavaMatchFilter STATIC_FILTER = new StaticFilter();
    private static final JavaMatchFilter NON_STATIC_FILTER = new NonStaticFilter();
    private static final JavaMatchFilter DEPRECATED_FILTER = new DeprecatedFilter();
    private static final JavaMatchFilter NON_DEPRECATED_FILTER = new NonDeprecatedFilter();
    private static final JavaMatchFilter[] ALL_FILTERS = new JavaMatchFilter[]{POTENTIAL_FILTER, IMPORT_FILTER, JAVADOC_FILTER, READ_FILTER, WRITE_FILTER, POLYMORPHIC_FILTER, INEXACT_FILTER, ERASURE_FILTER, NON_PUBLIC_FILTER, STATIC_FILTER, NON_STATIC_FILTER, DEPRECATED_FILTER, NON_DEPRECATED_FILTER};

    JavaMatchFilter() {
    }

    public abstract boolean filters(JavaElementMatch var1);

    public abstract boolean isApplicable(JavaSearchQuery var1);

    public boolean filters(Match match) {
        if (match instanceof JavaElementMatch) {
            return this.filters((JavaElementMatch)match);
        }
        return false;
    }

    public static MatchFilter[] getLastUsedFilters() {
        String string = JavaPlugin.getDefault().getDialogSettings().get(SETTINGS_LAST_USED_FILTERS);
        if (string != null && string.length() > 0) {
            return JavaMatchFilter.decodeFiltersString(string);
        }
        return JavaMatchFilter.getDefaultFilters();
    }

    public static void setLastUsedFilters(MatchFilter[] filters) {
        String encoded = JavaMatchFilter.encodeFilters(filters);
        JavaPlugin.getDefault().getDialogSettings().put(SETTINGS_LAST_USED_FILTERS, encoded);
    }

    public static MatchFilter[] getDefaultFilters() {
        return new MatchFilter[]{IMPORT_FILTER};
    }

    private static String encodeFilters(MatchFilter[] enabledFilters) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < enabledFilters.length) {
            MatchFilter matchFilter = enabledFilters[i];
            buf.append(matchFilter.getID());
            buf.append(';');
            ++i;
        }
        return buf.toString();
    }

    private static JavaMatchFilter[] decodeFiltersString(String encodedString) {
        StringTokenizer tokenizer = new StringTokenizer(encodedString, String.valueOf(';'));
        HashSet<JavaMatchFilter> result = new HashSet<JavaMatchFilter>();
        while (tokenizer.hasMoreTokens()) {
            JavaMatchFilter curr = JavaMatchFilter.findMatchFilter(tokenizer.nextToken());
            if (curr == null) continue;
            result.add(curr);
        }
        return result.toArray(new JavaMatchFilter[result.size()]);
    }

    public static JavaMatchFilter[] allFilters() {
        return ALL_FILTERS;
    }

    public static JavaMatchFilter[] allFilters(JavaSearchQuery query) {
        ArrayList<JavaMatchFilter> res = new ArrayList<JavaMatchFilter>();
        int i = 0;
        while (i < ALL_FILTERS.length) {
            JavaMatchFilter curr = ALL_FILTERS[i];
            if (curr.isApplicable(query)) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new JavaMatchFilter[res.size()]);
    }

    private static JavaMatchFilter findMatchFilter(String id) {
        int i = 0;
        while (i < ALL_FILTERS.length) {
            JavaMatchFilter matchFilter = ALL_FILTERS[i];
            if (matchFilter.getID().equals(id)) {
                return matchFilter;
            }
            ++i;
        }
        return null;
    }
}

