/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class InlineMethodAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public InlineMethodAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public InlineMethodAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.InlineMethodAction_inline_Method);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.inline_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        block2: {
            try {
                this.setEnabled(RefactoringAvailabilityTester.isInlineMethodAvailable(selection));
            }
            catch (JavaModelException e) {
                if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) break block2;
                JavaPlugin.log(e);
            }
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            Assert.isTrue((boolean)RefactoringAvailabilityTester.isInlineMethodAvailable(selection));
            IMethod method = (IMethod)selection.getFirstElement();
            ISourceRange nameRange = method.getNameRange();
            this.run(nameRange.getOffset(), nameRange.getLength(), method.getTypeRoot());
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), RefactoringMessages.InlineMethodAction_dialog_title, RefactoringMessages.InlineMethodAction_unexpected_exception);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isInlineMethodAvailable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(ITextSelection selection) {
        ITypeRoot typeRoot = SelectionConverter.getInputAsTypeRoot(this.fEditor);
        if (typeRoot == null) {
            return;
        }
        if (!JavaElementUtil.isSourceAvailable((ISourceReference)typeRoot)) {
            return;
        }
        this.run(selection.getOffset(), selection.getLength(), typeRoot);
    }

    private void run(int offset, int length, ITypeRoot typeRoot) {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)typeRoot)) {
            return;
        }
        CompilationUnit compilationUnit = RefactoringASTParser.parseWithASTProvider(typeRoot, true, null);
        if (!RefactoringExecutionStarter.startInlineMethodRefactoring(typeRoot, compilationUnit, offset, length, this.getShell())) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.InlineMethodAction_dialog_title, (String)RefactoringMessages.InlineMethodAction_no_method_invocation_or_declaration_selected);
        }
    }

    public boolean tryInlineMethod(ITypeRoot typeRoot, CompilationUnit node, ITextSelection selection, Shell shell) {
        return RefactoringExecutionStarter.startInlineMethodRefactoring(typeRoot, node, selection.getOffset(), selection.getLength(), shell);
    }
}

