/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.uuid;

import org.apache.commons.codec.binary.Hex;
import org.apache.directory.shared.ldap.util.StringTools;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.HexValueEditor;

public class InPlaceUuidValueEditor
extends HexValueEditor {
    private static final String UUID_REGEX = "^[A-Fa-f0-9]{8}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{12}$";

    public String getDisplayValue(IValue value) {
        Object rawValue;
        if (!this.showRawValues() && (rawValue = super.getRawValue(value)) instanceof byte[]) {
            byte[] bytes = (byte[])rawValue;
            String string = StringTools.utf8ToString((byte[])bytes);
            if (string.matches(UUID_REGEX) || StringTools.isEmpty((String)string)) {
                return string;
            }
            return this.convertToString(bytes);
        }
        return super.getDisplayValue(value);
    }

    String convertToString(byte[] bytes) {
        if (bytes == null || bytes.length != 16) {
            return "Invalid UUID";
        }
        char[] hex = Hex.encodeHex((byte[])bytes);
        StringBuffer sb = new StringBuffer();
        sb.append(hex, 0, 8);
        sb.append('-');
        sb.append(hex, 8, 4);
        sb.append('-');
        sb.append(hex, 12, 4);
        sb.append('-');
        sb.append(hex, 16, 4);
        sb.append('-');
        sb.append(hex, 20, 12);
        return sb.toString().toLowerCase();
    }
}

