/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.time;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.apache.directory.shared.ldap.util.GeneralizedTime;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.valueeditors.ValueEditorsActivator;
import org.apache.directory.studio.valueeditors.time.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class GeneralizedTimeValueDialog
extends Dialog {
    private GeneralizedTime value;
    private ArrayList<TimeZone> allTimezonesList = new ArrayList();
    private Map<Integer, TimeZone> utcTimezonesMap = new HashMap<Integer, TimeZone>();
    private Spinner hoursSpinner;
    private Spinner minutesSpinner;
    private Spinner secondsSpinner;
    private DateTime dateCalendar;
    private ComboViewer timezoneComboViewer;
    private Text rawValueText;
    private Label rawValueValidatorImage;
    private Button okButton;
    private ModifyListener hoursModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            GeneralizedTimeValueDialog.this.updateValueFromNonRawFields();
            GeneralizedTimeValueDialog.this.removeListeners();
            GeneralizedTimeValueDialog.this.updateRawFields();
            GeneralizedTimeValueDialog.this.addListeners();
        }
    };
    private ModifyListener minutesModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            GeneralizedTimeValueDialog.this.updateValueFromNonRawFields();
            GeneralizedTimeValueDialog.this.removeListeners();
            GeneralizedTimeValueDialog.this.updateRawFields();
            GeneralizedTimeValueDialog.this.addListeners();
        }
    };
    private ModifyListener secondsModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            GeneralizedTimeValueDialog.this.updateValueFromNonRawFields();
            GeneralizedTimeValueDialog.this.removeListeners();
            GeneralizedTimeValueDialog.this.updateRawFields();
            GeneralizedTimeValueDialog.this.addListeners();
        }
    };
    private SelectionListener dateSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            GeneralizedTimeValueDialog.this.updateValueFromNonRawFields();
            GeneralizedTimeValueDialog.this.removeListeners();
            GeneralizedTimeValueDialog.this.updateRawFields();
            GeneralizedTimeValueDialog.this.addListeners();
        }
    };
    private ISelectionChangedListener timezoneSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            GeneralizedTimeValueDialog.this.updateValueFromNonRawFields();
            GeneralizedTimeValueDialog.this.removeListeners();
            GeneralizedTimeValueDialog.this.updateRawFields();
            GeneralizedTimeValueDialog.this.addListeners();
        }
    };
    private ModifyListener rawValueModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            try {
                GeneralizedTimeValueDialog.this.value = new GeneralizedTime(GeneralizedTimeValueDialog.this.rawValueText.getText());
                GeneralizedTimeValueDialog.this.removeListeners();
                GeneralizedTimeValueDialog.this.updateNonRawFields();
                GeneralizedTimeValueDialog.this.addListeners();
                GeneralizedTimeValueDialog.this.validateRawValue(true);
            }
            catch (ParseException e1) {
                GeneralizedTimeValueDialog.this.validateRawValue(false);
                return;
            }
        }
    };

    public GeneralizedTimeValueDialog(Shell parentShell, GeneralizedTime value) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.value = value;
        if (this.value == null) {
            this.value = new GeneralizedTime(Calendar.getInstance());
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("GeneralizedTimeValueDialog.DateAndTimeEditor"));
        shell.setImage(ValueEditorsActivator.getDefault().getImage("resources/icons/generalizedtimeeditor.gif"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite dualComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)2, (int)1);
        this.createTimeDialogArea(dualComposite);
        this.createDateDialogArea(dualComposite);
        this.createTimeZoneDialogArea(dualComposite);
        this.createRawValueDialogArea(dualComposite);
        this.initWithInitialValue();
        this.addListeners();
        GeneralizedTimeValueDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createTimeDialogArea(Composite parent) {
        Label timeLabel = new Label(parent, 0);
        timeLabel.setText(Messages.getString("GeneralizedTimeValueDialog.Time"));
        Composite rightComposite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)5, (int)1);
        this.hoursSpinner = new Spinner(rightComposite, 2048);
        this.hoursSpinner.setMinimum(0);
        this.hoursSpinner.setMaximum(23);
        this.hoursSpinner.setTextLimit(2);
        this.hoursSpinner.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Label label1 = BaseWidgetUtils.createLabel((Composite)rightComposite, (String)":", (int)1);
        label1.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.minutesSpinner = new Spinner(rightComposite, 2048);
        this.minutesSpinner.setMinimum(0);
        this.minutesSpinner.setMaximum(59);
        this.minutesSpinner.setTextLimit(2);
        this.minutesSpinner.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        Label label2 = BaseWidgetUtils.createLabel((Composite)rightComposite, (String)":", (int)1);
        label2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.secondsSpinner = new Spinner(rightComposite, 2048);
        this.secondsSpinner.setMinimum(0);
        this.secondsSpinner.setMaximum(59);
        this.secondsSpinner.setTextLimit(2);
        this.secondsSpinner.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
    }

    private void createDateDialogArea(Composite parent) {
        Label dateLabel = BaseWidgetUtils.createLabel((Composite)parent, (String)Messages.getString("GeneralizedTimeValueDialog.Date"), (int)1);
        dateLabel.setLayoutData((Object)new GridData(0, 128, false, false));
        Composite rightComposite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        this.dateCalendar = new DateTime(rightComposite, 3072);
        this.dateCalendar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createTimeZoneDialogArea(Composite parent) {
        BaseWidgetUtils.createLabel((Composite)parent, (String)Messages.getString("GeneralizedTimeValueDialog.Timezone"), (int)1);
        this.timezoneComboViewer = new ComboViewer(parent);
        this.timezoneComboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.timezoneComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.timezoneComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((TimeZone)element).getID();
            }
        });
        this.initAllTimezones();
        this.timezoneComboViewer.setInput(this.allTimezonesList);
    }

    private void initAllTimezones() {
        this.initUtcTimezones();
        this.initContinentsAndCitiesTimezones();
    }

    private void initUtcTimezones() {
        this.addUtcTimezone("UTC-12", -43200000);
        this.addUtcTimezone("UTC-11", -39600000);
        this.addUtcTimezone("UTC-10", -36000000);
        this.addUtcTimezone("UTC-9:30", -34200000);
        this.addUtcTimezone("UTC-9", -32400000);
        this.addUtcTimezone("UTC-8", -28800000);
        this.addUtcTimezone("UTC-7", -25200000);
        this.addUtcTimezone("UTC-6", -21600000);
        this.addUtcTimezone("UTC-5", -18000000);
        this.addUtcTimezone("UTC-4:30", -16200000);
        this.addUtcTimezone("UTC-4", -14400000);
        this.addUtcTimezone("UTC-3:30", -12600000);
        this.addUtcTimezone("UTC-3", -10800000);
        this.addUtcTimezone("UTC-2", -7200000);
        this.addUtcTimezone("UTC-1", -3600000);
        this.addUtcTimezone("UTC", 0);
        this.addUtcTimezone("UTC+1", 3600000);
        this.addUtcTimezone("UTC+2", 0x6DDD00);
        this.addUtcTimezone("UTC+3", 10800000);
        this.addUtcTimezone("UTC+3:30", 12600000);
        this.addUtcTimezone("UTC+4", 14400000);
        this.addUtcTimezone("UTC+4:30", 16200000);
        this.addUtcTimezone("UTC+5", 18000000);
        this.addUtcTimezone("UTC+5:30", 19800000);
        this.addUtcTimezone("UTC+5:45", 20700000);
        this.addUtcTimezone("UTC+6", 21600000);
        this.addUtcTimezone("UTC+6:30", 23400000);
        this.addUtcTimezone("UTC+7", 25200000);
        this.addUtcTimezone("UTC+8", 28800000);
        this.addUtcTimezone("UTC+8:45", 31500000);
        this.addUtcTimezone("UTC+9", 32400000);
        this.addUtcTimezone("UTC+9:30", 34200000);
        this.addUtcTimezone("UTC+10", 36000000);
        this.addUtcTimezone("UTC+10:30", 37800000);
        this.addUtcTimezone("UTC+11", 39600000);
        this.addUtcTimezone("UTC+11:30", 41400000);
        this.addUtcTimezone("UTC+12", 43200000);
        this.addUtcTimezone("UTC+12:45", 45900000);
        this.addUtcTimezone("UTC+13", 46800000);
        this.addUtcTimezone("UTC+14", 50400000);
    }

    private void addUtcTimezone(String id, int rawOffset) {
        TimeZone tz = rawOffset == 0 ? TimeZone.getTimeZone("UTC") : new SimpleTimeZone(rawOffset, id);
        this.allTimezonesList.add(tz);
        this.utcTimezonesMap.put(rawOffset, tz);
    }

    private void initContinentsAndCitiesTimezones() {
        ArrayList<TimeZone> continentsAndCitiesTimezonesList = new ArrayList<TimeZone>();
        for (String timezoneId : TimeZone.getAvailableIDs()) {
            if (!timezoneId.matches("^(Africa|America|Asia|Atlantic|Australia|Europe|Indian|Pacific)/.*")) continue;
            continentsAndCitiesTimezonesList.add(TimeZone.getTimeZone(timezoneId));
        }
        Collections.sort(continentsAndCitiesTimezonesList, new Comparator<TimeZone>(){

            @Override
            public int compare(TimeZone a, TimeZone b) {
                return a.getID().compareTo(b.getID());
            }
        });
        this.allTimezonesList.addAll(continentsAndCitiesTimezonesList);
    }

    private void createRawValueDialogArea(Composite parent) {
        Label separatorLabel = new Label(parent, 258);
        separatorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        BaseWidgetUtils.createLabel((Composite)parent, (String)Messages.getString("GeneralizedTimeValueDialog.RawValue"), (int)1);
        Composite rawValueComposite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)2, (int)1);
        this.rawValueText = BaseWidgetUtils.createText((Composite)rawValueComposite, (String)"", (int)1);
        this.rawValueValidatorImage = new Label(rawValueComposite, 0);
        this.validateRawValue(true);
    }

    private void initWithInitialValue() {
        this.updateNonRawFields();
        this.updateRawFields();
    }

    private void updateNonRawFields() {
        Calendar calendar = this.value.getCalendar();
        this.hoursSpinner.setSelection(calendar.get(11));
        this.minutesSpinner.setSelection(calendar.get(12));
        this.secondsSpinner.setSelection(calendar.get(13));
        this.dateCalendar.setDate(calendar.get(1), calendar.get(2), calendar.get(5));
        TimeZone timezone = this.utcTimezonesMap.get(new Integer(calendar.getTimeZone().getRawOffset()));
        if (timezone == null) {
            this.timezoneComboViewer.setSelection(null);
        } else {
            this.timezoneComboViewer.setSelection((ISelection)new StructuredSelection((Object)timezone));
        }
    }

    private void updateRawFields() {
        this.rawValueText.setText(this.value.toGeneralizedTime());
        this.validateRawValue(true);
    }

    private void validateRawValue(boolean bool) {
        if (bool) {
            this.rawValueValidatorImage.setImage(ValueEditorsActivator.getDefault().getImage("resources/icons/textfield_ok.png"));
        } else {
            this.rawValueValidatorImage.setImage(ValueEditorsActivator.getDefault().getImage("resources/icons/textfield_error.png"));
        }
        if (this.okButton != null && !this.okButton.isDisposed()) {
            this.okButton.setEnabled(bool);
        }
    }

    private void addListeners() {
        this.hoursSpinner.addModifyListener(this.hoursModifyListener);
        this.minutesSpinner.addModifyListener(this.minutesModifyListener);
        this.secondsSpinner.addModifyListener(this.secondsModifyListener);
        this.dateCalendar.addSelectionListener(this.dateSelectionListener);
        this.timezoneComboViewer.addSelectionChangedListener(this.timezoneSelectionChangedListener);
        this.rawValueText.addModifyListener(this.rawValueModifyListener);
    }

    private void removeListeners() {
        this.hoursSpinner.removeModifyListener(this.hoursModifyListener);
        this.minutesSpinner.removeModifyListener(this.minutesModifyListener);
        this.secondsSpinner.removeModifyListener(this.secondsModifyListener);
        this.dateCalendar.removeSelectionListener(this.dateSelectionListener);
        this.timezoneComboViewer.removeSelectionChangedListener(this.timezoneSelectionChangedListener);
        this.rawValueText.removeModifyListener(this.rawValueModifyListener);
    }

    private void updateValueFromNonRawFields() {
        Calendar calendar = this.value.getCalendar();
        calendar.set(11, this.hoursSpinner.getSelection());
        calendar.set(12, this.minutesSpinner.getSelection());
        calendar.set(13, this.secondsSpinner.getSelection());
        calendar.set(1, this.dateCalendar.getYear());
        calendar.set(2, this.dateCalendar.getMonth());
        calendar.set(5, this.dateCalendar.getDay());
        StructuredSelection selection = (StructuredSelection)this.timezoneComboViewer.getSelection();
        if (selection != null && !selection.isEmpty()) {
            calendar.setTimeZone((TimeZone)selection.getFirstElement());
        }
    }

    public GeneralizedTime getGeneralizedTime() {
        return this.value;
    }
}

