/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.password;

import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.AbstractDialogBinaryValueEditor;
import org.apache.directory.studio.valueeditors.password.Messages;
import org.apache.directory.studio.valueeditors.password.PasswordDialog;
import org.eclipse.swt.widgets.Shell;

public class PasswordValueEditor
extends AbstractDialogBinaryValueEditor {
    protected boolean openDialog(Shell shell) {
        byte[] pw;
        PasswordDialog dialog;
        PasswordValueEditorRawValueWrapper wrapper;
        Object value = this.getValue();
        if (value != null && value instanceof PasswordValueEditorRawValueWrapper && (wrapper = (PasswordValueEditorRawValueWrapper)value).password != null && wrapper.password instanceof byte[] && (dialog = new PasswordDialog(shell, pw = (byte[])wrapper.password, wrapper.entry)).open() == 0) {
            this.setValue(dialog.getNewPassword());
            return true;
        }
        return false;
    }

    public String getDisplayValue(IValue value) {
        String text;
        if (this.showRawValues()) {
            return PasswordValueEditor.getPrintableString((IValue)value);
        }
        if (value == null) {
            return "NULL";
        }
        String password = value.getStringValue();
        if (password == null) {
            return "NULL";
        }
        if ("".equals(password)) {
            text = Messages.getString("PasswordValueEditor.EmptyPassword");
        } else if (password.indexOf(123) == 0 && password.indexOf(125) > 0) {
            String hashMethod = password.substring(password.indexOf(123) + 1, password.indexOf(125));
            text = hashMethod + Messages.getString("PasswordValueEditor.HashedPassword");
        } else {
            text = Messages.getString("PasswordValueEditor.PlainTextPassword");
        }
        return text;
    }

    protected Object getEmptyRawValue(IAttribute attribute) {
        return new PasswordValueEditorRawValueWrapper(new byte[0], attribute.getEntry());
    }

    public Object getRawValue(IValue value) {
        Object password = super.getRawValue(value);
        return new PasswordValueEditorRawValueWrapper(password, value.getAttribute().getEntry());
    }

    private class PasswordValueEditorRawValueWrapper {
        private Object password;
        private IEntry entry;

        private PasswordValueEditorRawValueWrapper(Object password, IEntry entry) {
            this.password = password;
            this.entry = entry;
        }
    }
}

