/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.password;

import java.util.Arrays;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.jobs.CheckBindRunnable;
import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.Password;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.valueeditors.ValueEditorsActivator;
import org.apache.directory.studio.valueeditors.password.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class PasswordDialog
extends Dialog {
    private static final String[] HASH_METHODS = new String[]{"SHA", "SSHA", "MD5", "SMD5", "CRYPT", Password.HASH_METHOD_NO};
    private static final int CURRENT_TAB = 0;
    private static final int NEW_TAB = 1;
    private static final String SELECTED_TAB_DIALOGSETTINGS_KEY = PasswordDialog.class.getName() + ".tab";
    private static final String SELECTED_HASH_METHOD_DIALOGSETTINGS_KEY = PasswordDialog.class.getName() + ".hashMethod";
    private TabFolder tabFolder;
    private TabItem currentTab;
    private TabItem newTab;
    private IEntry entry;
    private Password currentPassword;
    private Composite currentPasswordContainer;
    private Text currentPasswordText;
    private Text currentPasswordHashMethodText;
    private Text currentPasswordValueHexText;
    private Text currentPasswordSaltHexText;
    private Button showCurrentPasswordDetailsButton;
    private Text testPasswordText;
    private Text testBindDnText;
    private Button showTestPasswordDetailsButton;
    private Button verifyPasswordButton;
    private Button bindPasswordButton;
    private Password newPassword;
    private Composite newPasswordContainer;
    private Text newPasswordText;
    private Combo newPasswordHashMethodCombo;
    private Text newPasswordPreviewText;
    private Text newPasswordPreviewValueHexText;
    private Text newPasswordPreviewSaltHexText;
    private Button newSaltButton;
    private Button showNewPasswordDetailsButton;
    private byte[] returnPassword;
    private Button okButton;

    public PasswordDialog(Shell parentShell, byte[] currentPassword, IEntry entry) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        try {
            this.currentPassword = currentPassword != null ? new Password(currentPassword) : null;
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.entry = entry;
        this.returnPassword = null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("PasswordDialog.PasswordEditor"));
        shell.setImage(ValueEditorsActivator.getDefault().getImage("resources/icons/passwordeditor.gif"));
    }

    protected void okPressed() {
        this.returnPassword = (byte[])(this.newPassword != null ? this.newPassword.toBytes() : null);
        ValueEditorsActivator.getDefault().getDialogSettings().put(SELECTED_HASH_METHOD_DIALOGSETTINGS_KEY, this.newPasswordHashMethodCombo.getText());
        super.okPressed();
    }

    public boolean close() {
        ValueEditorsActivator.getDefault().getDialogSettings().put(SELECTED_TAB_DIALOGSETTINGS_KEY, this.tabFolder.getSelectionIndex());
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        try {
            int tabIndex = ValueEditorsActivator.getDefault().getDialogSettings().getInt(SELECTED_TAB_DIALOGSETTINGS_KEY);
            if (this.currentPassword == null || this.currentPassword.toBytes().length == 0) {
                tabIndex = 1;
            }
            this.tabFolder.setSelection(tabIndex);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String hashMethod = ValueEditorsActivator.getDefault().getDialogSettings().get(SELECTED_HASH_METHOD_DIALOGSETTINGS_KEY);
            if (Arrays.asList(HASH_METHODS).contains(hashMethod)) {
                this.newPasswordHashMethodCombo.setText(hashMethod);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateTabFolder();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300) * 3 / 2;
        gd.heightHint = this.convertVerticalDLUsToPixels(300) * 2 / 3;
        composite.setLayoutData((Object)gd);
        this.tabFolder = new TabFolder(composite, 128);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        this.tabFolder.setLayout((Layout)mainLayout);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PasswordDialog.this.updateTabFolder();
            }
        });
        if (this.currentPassword != null && this.currentPassword.toBytes().length > 0) {
            this.currentPasswordContainer = new Composite((Composite)this.tabFolder, 0);
            GridLayout currentLayout = new GridLayout(2, false);
            currentLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
            currentLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            currentLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            currentLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            this.currentPasswordContainer.setLayout((Layout)currentLayout);
            BaseWidgetUtils.createLabel((Composite)this.currentPasswordContainer, (String)(Messages.getString("PasswordDialog.CurrentPassword") + ":"), (int)1);
            this.currentPasswordText = BaseWidgetUtils.createReadonlyText((Composite)this.currentPasswordContainer, (String)"", (int)1);
            new Label(this.currentPasswordContainer, 0);
            Composite currentPasswordDetailContainer = BaseWidgetUtils.createColumnContainer((Composite)this.currentPasswordContainer, (int)2, (int)1);
            BaseWidgetUtils.createLabel((Composite)currentPasswordDetailContainer, (String)Messages.getString("PasswordDialog.HashMethod"), (int)1);
            this.currentPasswordHashMethodText = BaseWidgetUtils.createLabeledText((Composite)currentPasswordDetailContainer, (String)"", (int)1);
            BaseWidgetUtils.createLabel((Composite)currentPasswordDetailContainer, (String)Messages.getString("PasswordDialog.PasswordHex"), (int)1);
            this.currentPasswordValueHexText = BaseWidgetUtils.createLabeledText((Composite)currentPasswordDetailContainer, (String)"", (int)1);
            BaseWidgetUtils.createLabel((Composite)currentPasswordDetailContainer, (String)Messages.getString("PasswordDialog.SaltHex"), (int)1);
            this.currentPasswordSaltHexText = BaseWidgetUtils.createLabeledText((Composite)currentPasswordDetailContainer, (String)"", (int)1);
            this.showCurrentPasswordDetailsButton = BaseWidgetUtils.createCheckbox((Composite)currentPasswordDetailContainer, (String)Messages.getString("PasswordDialog.ShowCurrentPasswordDetails"), (int)1);
            this.showCurrentPasswordDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    PasswordDialog.this.updateCurrentPasswordGroup();
                }
            });
            BaseWidgetUtils.createLabel((Composite)this.currentPasswordContainer, (String)Messages.getString("PasswordDialog.VerifyPassword"), (int)1);
            this.testPasswordText = BaseWidgetUtils.createText((Composite)this.currentPasswordContainer, (String)"", (int)1);
            this.testPasswordText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PasswordDialog.this.updateCurrentPasswordGroup();
                }
            });
            new Label(this.currentPasswordContainer, 0);
            Composite testPasswordDetailContainer = BaseWidgetUtils.createColumnContainer((Composite)this.currentPasswordContainer, (int)2, (int)1);
            BaseWidgetUtils.createLabel((Composite)testPasswordDetailContainer, (String)Messages.getString("PasswordDialog.BindDn"), (int)1);
            this.testBindDnText = BaseWidgetUtils.createLabeledText((Composite)testPasswordDetailContainer, (String)"", (int)1);
            this.showTestPasswordDetailsButton = BaseWidgetUtils.createCheckbox((Composite)testPasswordDetailContainer, (String)Messages.getString("PasswordDialog.ShowTestPasswordDetails"), (int)2);
            this.showTestPasswordDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    PasswordDialog.this.updateCurrentPasswordGroup();
                }
            });
            new Label(this.currentPasswordContainer, 0);
            Composite verifyPasswordButtonContainer = BaseWidgetUtils.createColumnContainer((Composite)this.currentPasswordContainer, (int)2, (int)1);
            this.verifyPasswordButton = BaseWidgetUtils.createButton((Composite)verifyPasswordButtonContainer, (String)Messages.getString("PasswordDialog.Verify"), (int)1);
            this.verifyPasswordButton.setEnabled(false);
            this.verifyPasswordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    PasswordDialog.this.verifyCurrentPassword();
                }
            });
            this.bindPasswordButton = BaseWidgetUtils.createButton((Composite)verifyPasswordButtonContainer, (String)Messages.getString("PasswordDialog.Bind"), (int)1);
            this.bindPasswordButton.setEnabled(false);
            this.bindPasswordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    PasswordDialog.this.bindCurrentPassword();
                }
            });
            this.currentTab = new TabItem(this.tabFolder, 0);
            this.currentTab.setText(Messages.getString("PasswordDialog.CurrentPassword"));
            this.currentTab.setControl((Control)this.currentPasswordContainer);
        }
        this.newPasswordContainer = new Composite((Composite)this.tabFolder, 0);
        GridLayout newLayout = new GridLayout(2, false);
        newLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        newLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        newLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        newLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.newPasswordContainer.setLayout((Layout)newLayout);
        BaseWidgetUtils.createLabel((Composite)this.newPasswordContainer, (String)Messages.getString("PasswordDialog.EnterNewPassword"), (int)1);
        this.newPasswordText = BaseWidgetUtils.createText((Composite)this.newPasswordContainer, (String)"", (int)1);
        this.newPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PasswordDialog.this.updateNewPasswordGroup();
            }
        });
        BaseWidgetUtils.createLabel((Composite)this.newPasswordContainer, (String)Messages.getString("PasswordDialog.SelectHashMethod"), (int)1);
        this.newPasswordHashMethodCombo = BaseWidgetUtils.createReadonlyCombo((Composite)this.newPasswordContainer, (String[])HASH_METHODS, (int)0, (int)1);
        this.newPasswordHashMethodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PasswordDialog.this.updateNewPasswordGroup();
            }
        });
        BaseWidgetUtils.createLabel((Composite)this.newPasswordContainer, (String)Messages.getString("PasswordDialog.PasswordPreview"), (int)1);
        this.newPasswordPreviewText = BaseWidgetUtils.createReadonlyText((Composite)this.newPasswordContainer, (String)"", (int)1);
        this.newSaltButton = BaseWidgetUtils.createButton((Composite)this.newPasswordContainer, (String)Messages.getString("PasswordDialog.NewSalt"), (int)1);
        this.newSaltButton.setLayoutData((Object)new GridData());
        this.newSaltButton.setEnabled(false);
        this.newSaltButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PasswordDialog.this.updateNewPasswordGroup();
            }
        });
        Composite newPasswordPreviewDetailContainer = BaseWidgetUtils.createColumnContainer((Composite)this.newPasswordContainer, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)newPasswordPreviewDetailContainer, (String)Messages.getString("PasswordDialog.PasswordHex"), (int)1);
        this.newPasswordPreviewValueHexText = BaseWidgetUtils.createLabeledText((Composite)newPasswordPreviewDetailContainer, (String)":", (int)1);
        BaseWidgetUtils.createLabel((Composite)newPasswordPreviewDetailContainer, (String)Messages.getString("PasswordDialog.SaltHex"), (int)1);
        this.newPasswordPreviewSaltHexText = BaseWidgetUtils.createLabeledText((Composite)newPasswordPreviewDetailContainer, (String)"", (int)1);
        this.showNewPasswordDetailsButton = BaseWidgetUtils.createCheckbox((Composite)newPasswordPreviewDetailContainer, (String)Messages.getString("PasswordDialog.ShowNewPasswordDetails"), (int)1);
        this.showNewPasswordDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PasswordDialog.this.updateNewPasswordGroup();
            }
        });
        this.newTab = new TabItem(this.tabFolder, 0);
        this.newTab.setText(Messages.getString("PasswordDialog.NewPassword"));
        this.newTab.setControl((Control)this.newPasswordContainer);
        PasswordDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void updateCurrentPasswordGroup() {
        if (this.currentPassword != null) {
            this.currentPasswordHashMethodText.setText(Utils.getNonNullString((Object)this.currentPassword.getHashMethod()));
            this.currentPasswordValueHexText.setText(Utils.getNonNullString((Object)this.currentPassword.getHashedPasswordAsHexString()));
            this.currentPasswordSaltHexText.setText(Utils.getNonNullString((Object)this.currentPassword.getSaltAsHexString()));
            this.currentPasswordText.setText(this.currentPassword.toString());
        }
        if (this.showCurrentPasswordDetailsButton.getSelection()) {
            this.currentPasswordText.setEchoChar('\u0000');
            this.currentPasswordValueHexText.setEchoChar('\u0000');
            this.currentPasswordSaltHexText.setEchoChar('\u0000');
        } else {
            this.currentPasswordText.setEchoChar('\u2022');
            this.currentPasswordValueHexText.setEchoChar('\u2022');
            this.currentPasswordSaltHexText.setEchoChar(this.currentPasswordSaltHexText.getText().equals(Utils.getNonNullString(null)) ? (char)'\u0000' : '\u2022');
        }
        this.testPasswordText.setEnabled(this.currentPassword != null && this.currentPassword.getHashedPassword() != null && this.currentPassword.toBytes().length > 0);
        this.testBindDnText.setText(this.entry != null ? this.entry.getDn().getUpName() : Utils.getNonNullString(null));
        if (this.showTestPasswordDetailsButton.getSelection()) {
            this.testPasswordText.setEchoChar('\u0000');
        } else {
            this.testPasswordText.setEchoChar('\u2022');
        }
        this.verifyPasswordButton.setEnabled(this.testPasswordText.isEnabled() && !"".equals(this.testPasswordText.getText()));
        this.bindPasswordButton.setEnabled(this.testPasswordText.isEnabled() && !"".equals(this.testPasswordText.getText()) && this.entry != null && this.entry.getBrowserConnection().getConnection() != null);
        if (this.verifyPasswordButton.isEnabled()) {
            this.getShell().setDefaultButton(this.verifyPasswordButton);
        } else {
            this.getShell().setDefaultButton(this.okButton);
        }
    }

    private void verifyCurrentPassword() {
        String testPassword = this.testPasswordText.getText();
        if (this.currentPassword != null) {
            if (this.currentPassword.verify(testPassword)) {
                MessageDialog dialog = new MessageDialog(this.getShell(), Messages.getString("PasswordDialog.PasswordVerification"), this.getShell().getImage(), Messages.getString("PasswordDialog.PasswordVerifiedSuccessfully"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.open();
            } else {
                MessageDialog dialog = new MessageDialog(this.getShell(), Messages.getString("PasswordDialog.PasswordVerification"), this.getShell().getImage(), Messages.getString("PasswordDialog.PasswordVerificationFailed"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.open();
            }
        }
    }

    private void bindCurrentPassword() {
        if (!"".equals(this.testPasswordText.getText()) && this.entry != null && this.entry.getBrowserConnection().getConnection() != null) {
            Connection connection = (Connection)this.entry.getBrowserConnection().getConnection().clone();
            connection.getConnectionParameter().setName(null);
            connection.getConnectionParameter().setBindPrincipal(this.entry.getDn().getUpName());
            connection.getConnectionParameter().setBindPassword(this.testPasswordText.getText());
            connection.getConnectionParameter().setAuthMethod(ConnectionParameter.AuthenticationMethod.SIMPLE);
            CheckBindRunnable runnable = new CheckBindRunnable(connection);
            IStatus status = RunnableContextRunner.execute((StudioRunnableWithProgress)runnable, null, (boolean)true);
            if (status.isOK()) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("PasswordDialog.CheckAuthentication"), (String)Messages.getString("PasswordDialog.AuthenticationSuccessful"));
            }
        }
    }

    private void updateNewPasswordGroup() {
        this.newPassword = new Password(this.newPasswordHashMethodCombo.getText(), this.newPasswordText.getText());
        if (!"".equals(this.newPasswordText.getText()) || this.newPassword.getHashMethod() == null) {
            this.newPasswordPreviewValueHexText.setText(Utils.getNonNullString((Object)this.newPassword.getHashedPasswordAsHexString()));
            this.newPasswordPreviewSaltHexText.setText(Utils.getNonNullString((Object)this.newPassword.getSaltAsHexString()));
            this.newPasswordPreviewText.setText(this.newPassword.toString());
            this.newSaltButton.setEnabled(this.newPassword.getSalt() != null);
            this.okButton.setEnabled(true);
            this.getShell().setDefaultButton(this.okButton);
        } else {
            this.newPassword = null;
            this.newPasswordPreviewValueHexText.setText(Utils.getNonNullString(null));
            this.newPasswordPreviewSaltHexText.setText(Utils.getNonNullString(null));
            this.newPasswordPreviewText.setText(Utils.getNonNullString(null));
            this.newSaltButton.setEnabled(false);
            this.okButton.setEnabled(false);
        }
        if (this.showNewPasswordDetailsButton.getSelection()) {
            this.newPasswordText.setEchoChar('\u0000');
            this.newPasswordPreviewText.setEchoChar('\u0000');
            this.newPasswordPreviewValueHexText.setEchoChar('\u0000');
            this.newPasswordPreviewSaltHexText.setEchoChar('\u0000');
        } else {
            this.newPasswordText.setEchoChar('\u2022');
            this.newPasswordPreviewText.setEchoChar(this.newPasswordPreviewText.getText().equals(Utils.getNonNullString(null)) ? (char)'\u0000' : '\u2022');
            this.newPasswordPreviewValueHexText.setEchoChar(this.newPasswordPreviewValueHexText.getText().equals(Utils.getNonNullString(null)) ? (char)'\u0000' : '\u2022');
            this.newPasswordPreviewSaltHexText.setEchoChar(this.newPasswordPreviewSaltHexText.getText().equals(Utils.getNonNullString(null)) ? (char)'\u0000' : '\u2022');
        }
    }

    private void updateTabFolder() {
        if (this.testPasswordText != null && this.newPasswordText != null) {
            if (this.tabFolder.getSelectionIndex() == 0) {
                this.testPasswordText.setFocus();
            } else if (this.tabFolder.getSelectionIndex() == 1) {
                this.newPasswordText.setFocus();
            }
            this.updateCurrentPasswordGroup();
            this.updateNewPasswordGroup();
        }
    }

    public byte[] getNewPassword() {
        return this.returnPassword;
    }
}

