/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.objectclass;

import java.util.Arrays;
import java.util.Collection;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.ui.widgets.ExtendedContentAssistCommandAdapter;
import org.apache.directory.studio.ldapbrowser.common.widgets.ListContentProposalProvider;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.valueeditors.ValueEditorsActivator;
import org.apache.directory.studio.valueeditors.objectclass.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ObjectClassDialog
extends Dialog {
    private Schema schema;
    private String initialValue;
    private Combo objectClassCombo;
    private String returnValue;

    public ObjectClassDialog(Shell parentShell, Schema schema, String initialValue) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.initialValue = initialValue;
        this.schema = schema;
        this.returnValue = null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("ObjectClassDialog.ObjectClassEditor"));
        shell.setImage(ValueEditorsActivator.getDefault().getImage("resources/icons/objectclasseditor.png"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

    protected void okPressed() {
        this.returnValue = this.objectClassCombo.getText();
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        composite.setLayoutData((Object)gd);
        Object[] allOcNames = SchemaUtils.getNamesAsArray((Collection)this.schema.getObjectClassDescriptions());
        Arrays.sort(allOcNames);
        this.objectClassCombo = BaseWidgetUtils.createCombo((Composite)composite, (String[])new String[0], (int)-1, (int)1);
        this.objectClassCombo.setVisibleItemCount(20);
        this.objectClassCombo.setItems((String[])allOcNames);
        this.objectClassCombo.setText(this.initialValue);
        new ExtendedContentAssistCommandAdapter((Control)this.objectClassCombo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)new ListContentProposalProvider(this.objectClassCombo.getItems()), null, null, true);
        ObjectClassDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public String getObjectClass() {
        return this.returnValue;
    }
}

