/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.msad;

import org.apache.commons.codec.binary.Hex;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.HexValueEditor;

public class InPlaceMsAdObjectSidValueEditor
extends HexValueEditor {
    public String getDisplayValue(IValue value) {
        Object rawValue;
        if (!this.showRawValues() && (rawValue = super.getRawValue(value)) instanceof byte[]) {
            byte[] bytes = (byte[])rawValue;
            return this.convertToString(bytes);
        }
        return super.getDisplayValue(value);
    }

    protected String convertToString(byte[] bytes) {
        if (bytes == null || bytes.length < 8) {
            return "Invalid SID";
        }
        char[] hex = Hex.encodeHex((byte[])bytes);
        StringBuffer sb = new StringBuffer();
        sb.append('S');
        int revision = Integer.parseInt(new String(hex, 0, 2), 16);
        sb.append('-');
        sb.append(revision);
        int count = Integer.parseInt(new String(hex, 2, 2), 16);
        if (bytes.length != 8 + count * 4) {
            return "Invalid SID";
        }
        long authority = Long.parseLong(new String(hex, 4, 12), 16);
        sb.append('-');
        sb.append(authority);
        for (int i = 0; i < count; ++i) {
            StringBuffer rid = new StringBuffer();
            for (int k = 3; k >= 0; --k) {
                rid.append(hex[16 + i * 8 + k * 2]);
                rid.append(hex[16 + i * 8 + k * 2 + 1]);
            }
            long subAuthority = Long.parseLong(rid.toString(), 16);
            sb.append('-');
            sb.append(subAuthority);
        }
        return sb.toString();
    }
}

