/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.integer;

import org.apache.directory.studio.valueeditors.ValueEditorsActivator;
import org.apache.directory.studio.valueeditors.integer.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class IntegerDialog
extends Dialog {
    private int initialValue;
    private int returnValue;
    private Spinner spinner = null;

    public IntegerDialog(Shell parentShell, int initialValue) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.initialValue = initialValue;
        this.returnValue = -1;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("IntegerDialog.IntegerEditor"));
        shell.setImage(ValueEditorsActivator.getDefault().getImage("resources/icons/integereditor.gif"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.returnValue = this.spinner.getSelection();
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        this.spinner = new Spinner(composite, 2048);
        this.spinner.setMinimum(Integer.MIN_VALUE);
        this.spinner.setMaximum(Integer.MAX_VALUE);
        this.spinner.setDigits(0);
        this.spinner.setIncrement(1);
        this.spinner.setPageIncrement(100);
        this.spinner.setSelection(this.initialValue);
        this.spinner.setLayoutData((Object)new GridData(768));
        IntegerDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public int getInteger() {
        return this.returnValue;
    }

    public boolean isDirty() {
        return this.initialValue != this.returnValue;
    }
}

