/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.dn;

import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.ldapbrowser.common.dialogs.DnDialog;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.AbstractDialogStringValueEditor;
import org.apache.directory.studio.valueeditors.dn.Messages;
import org.eclipse.swt.widgets.Shell;

public class DnValueEditor
extends AbstractDialogStringValueEditor {
    protected boolean openDialog(Shell shell) {
        Object value = this.getValue();
        if (value != null && value instanceof DnValueEditorRawValueWrapper) {
            LdapDN dn;
            DnValueEditorRawValueWrapper wrapper = (DnValueEditorRawValueWrapper)value;
            try {
                dn = wrapper.dn != null ? new LdapDN(wrapper.dn) : null;
            }
            catch (InvalidNameException e) {
                dn = null;
            }
            DnDialog dialog = new DnDialog(shell, Messages.getString("DnValueEditor.DNEditor"), null, wrapper.connection, dn);
            if (dialog.open() == 0 && dialog.getDn() != null) {
                this.setValue(dialog.getDn().getUpName());
                return true;
            }
        }
        return false;
    }

    public Object getRawValue(AttributeHierarchy attributeHierarchy) {
        if (attributeHierarchy == null) {
            return null;
        }
        if (attributeHierarchy.size() == 1 && attributeHierarchy.getAttribute().getValueSize() == 0) {
            IBrowserConnection connection = attributeHierarchy.getAttribute().getEntry().getBrowserConnection();
            return new DnValueEditorRawValueWrapper(connection, null);
        }
        if (attributeHierarchy.size() == 1 && attributeHierarchy.getAttribute().getValueSize() == 1) {
            IBrowserConnection connection = attributeHierarchy.getAttribute().getEntry().getBrowserConnection();
            return new DnValueEditorRawValueWrapper(connection, this.getDisplayValue(attributeHierarchy));
        }
        return null;
    }

    public Object getRawValue(IValue value) {
        Object o = super.getRawValue(value);
        if (o != null && o instanceof String) {
            IBrowserConnection connection = value.getAttribute().getEntry().getBrowserConnection();
            return new DnValueEditorRawValueWrapper(connection, (String)o);
        }
        return null;
    }

    private class DnValueEditorRawValueWrapper {
        private IBrowserConnection connection;
        private String dn;

        private DnValueEditorRawValueWrapper(IBrowserConnection connection, String dn) {
            this.connection = connection;
            this.dn = dn;
        }

        public String toString() {
            return this.dn == null ? "" : this.dn;
        }
    }
}

