/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.widgets;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.jobs.CheckNetworkParameterRunnable;
import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.connection.ui.AbstractConnectionParameterPage;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.ui.widgets.HistoryUtils;
import org.apache.directory.studio.connection.ui.widgets.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NetworkParameterPage
extends AbstractConnectionParameterPage {
    private static final String X_CONNECTION_NAME = "X-CONNECTION-NAME";
    private static final String X_ENCRYPTION = "X-ENCRYPTION";
    private static final String X_ENCRYPTION_LDAPS = "ldaps";
    private static final String X_ENCRYPTION_START_TLS = "StartTLS";
    private Text nameText;
    private Combo hostCombo;
    private Combo portCombo;
    private Combo encryptionMethodCombo;
    private Button checkConnectionButton;

    private String getName() {
        return this.nameText.getText();
    }

    private String getHostName() {
        return this.hostCombo.getText();
    }

    private int getPort() {
        return Integer.parseInt(this.portCombo.getText());
    }

    private ConnectionParameter.EncryptionMethod getEncyrptionMethod() {
        switch (this.encryptionMethodCombo.getSelectionIndex()) {
            case 1: {
                return ConnectionParameter.EncryptionMethod.LDAPS;
            }
            case 2: {
                return ConnectionParameter.EncryptionMethod.START_TLS;
            }
        }
        return ConnectionParameter.EncryptionMethod.NONE;
    }

    private Connection getTestConnection() {
        ConnectionParameter cp = new ConnectionParameter(null, this.getHostName(), this.getPort(), this.getEncyrptionMethod(), ConnectionParameter.AuthenticationMethod.NONE, null, null, null, true, null);
        Connection conn = new Connection(cp);
        return conn;
    }

    protected void createComposite(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer(parent, 1, 1);
        Composite nameComposite = BaseWidgetUtils.createColumnContainer(composite, 2, 1);
        BaseWidgetUtils.createLabel(nameComposite, Messages.getString("NetworkParameterPage.ConnectionName"), 1);
        this.nameText = BaseWidgetUtils.createText(nameComposite, "", 1);
        BaseWidgetUtils.createSpacer(composite, 1);
        Group group = BaseWidgetUtils.createGroup(composite, Messages.getString("NetworkParameterPage.NetworkParameter"), 1);
        Composite groupComposite = BaseWidgetUtils.createColumnContainer((Composite)group, 3, 1);
        BaseWidgetUtils.createLabel(groupComposite, Messages.getString("NetworkParameterPage.HostName"), 1);
        String[] hostHistory = HistoryUtils.load("hostHistory");
        this.hostCombo = BaseWidgetUtils.createCombo(groupComposite, hostHistory, -1, 2);
        BaseWidgetUtils.createLabel(groupComposite, Messages.getString("NetworkParameterPage.Port"), 1);
        String[] portHistory = HistoryUtils.load("portHistory");
        this.portCombo = BaseWidgetUtils.createCombo(groupComposite, portHistory, -1, 2);
        this.portCombo.setTextLimit(5);
        this.portCombo.setText("389");
        String[] encMethods = new String[]{Messages.getString("NetworkParameterPage.NoEncryption"), Messages.getString("NetworkParameterPage.UseSSLEncryption"), Messages.getString("NetworkParameterPage.UseStartTLS")};
        int index = 0;
        BaseWidgetUtils.createLabel(groupComposite, Messages.getString("NetworkParameterPage.EncryptionMethod"), 1);
        this.encryptionMethodCombo = BaseWidgetUtils.createReadonlyCombo(groupComposite, encMethods, index, 2);
        boolean validateCertificates = ConnectionCorePlugin.getDefault().getPluginPreferences().getBoolean("validateCertificates");
        if (!validateCertificates) {
            BaseWidgetUtils.createSpacer(groupComposite, 1);
            BaseWidgetUtils.createLabel(groupComposite, Messages.getString("NetworkParameterPage.WarningCertificateValidation"), 2);
        }
        BaseWidgetUtils.createSpacer(groupComposite, 2);
        this.checkConnectionButton = new Button(groupComposite, 8);
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.verticalAlignment = 1024;
        this.checkConnectionButton.setLayoutData((Object)gd);
        this.checkConnectionButton.setText(Messages.getString("NetworkParameterPage.CheckNetworkParameter"));
        this.nameText.setFocus();
    }

    protected void validate() {
        this.checkConnectionButton.setEnabled(!this.hostCombo.getText().equals("") && !this.portCombo.getText().equals(""));
        this.message = null;
        this.infoMessage = null;
        this.errorMessage = null;
        if ("".equals(this.portCombo.getText())) {
            this.message = Messages.getString("NetworkParameterPage.PleaseEnterPort");
        }
        if ("".equals(this.hostCombo.getText())) {
            this.message = Messages.getString("NetworkParameterPage.PleaseEnterHostname");
        }
        if ("".equals(this.nameText.getText())) {
            this.message = Messages.getString("NetworkParameterPage.PleaseEnterConnectionName");
        }
        if (!(ConnectionCorePlugin.getDefault().getConnectionManager().getConnectionByName(this.nameText.getText()) == null || this.connectionParameter != null && this.nameText.getText().equals(this.connectionParameter.getName()))) {
            this.errorMessage = NLS.bind((String)Messages.getString("NetworkParameterPage.ConnectionExists"), (Object[])new String[]{this.nameText.getText()});
        }
    }

    protected void loadParameters(ConnectionParameter parameter) {
        this.connectionParameter = parameter;
        this.nameText.setText(parameter.getName());
        this.hostCombo.setText(parameter.getHost());
        this.portCombo.setText(Integer.toString(parameter.getPort()));
        int index = parameter.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.LDAPS ? 1 : (parameter.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.START_TLS ? 2 : 0);
        this.encryptionMethodCombo.select(index);
    }

    protected void initListeners() {
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NetworkParameterPage.this.connectionPageModified();
            }
        });
        this.hostCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NetworkParameterPage.this.connectionPageModified();
            }
        });
        this.portCombo.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                if (!event.text.matches("[0-9]*")) {
                    event.doit = false;
                }
            }
        });
        this.portCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NetworkParameterPage.this.connectionPageModified();
            }
        });
        this.encryptionMethodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NetworkParameterPage.this.connectionPageModified();
            }
        });
        this.checkConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Connection connection = NetworkParameterPage.this.getTestConnection();
                CheckNetworkParameterRunnable runnable = new CheckNetworkParameterRunnable(connection);
                IStatus status = RunnableContextRunner.execute((StudioRunnableWithProgress)runnable, NetworkParameterPage.this.runnableContext, true);
                if (status.isOK()) {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("NetworkParameterPage.CheckNetworkParameter"), (String)Messages.getString("NetworkParameterPage.ConnectionEstablished"));
                }
            }
        });
    }

    public void saveParameters(ConnectionParameter parameter) {
        parameter.setName(this.getName());
        parameter.setHost(this.getHostName());
        parameter.setPort(this.getPort());
        parameter.setEncryptionMethod(this.getEncyrptionMethod());
    }

    public void saveDialogSettings() {
        HistoryUtils.save("hostHistory", this.hostCombo.getText());
        HistoryUtils.save("portHistory", this.portCombo.getText());
    }

    public void setFocus() {
        this.nameText.setFocus();
    }

    public boolean areParametersModifed() {
        return this.isReconnectionRequired() || !StringUtils.equals((String)this.connectionParameter.getName(), (String)this.getName());
    }

    public boolean isReconnectionRequired() {
        return this.connectionParameter == null || !StringUtils.equals((String)this.connectionParameter.getHost(), (String)this.getHostName()) || this.connectionParameter.getPort() != this.getPort() || this.connectionParameter.getEncryptionMethod() != this.getEncyrptionMethod();
    }

    public void mergeParametersToLdapURL(ConnectionParameter parameter, LdapURL ldapUrl) {
        ldapUrl.getExtensions().add(new LdapURL.Extension(false, X_CONNECTION_NAME, parameter.getName()));
        ldapUrl.setHost(parameter.getHost());
        ldapUrl.setPort(parameter.getPort());
        switch (parameter.getEncryptionMethod()) {
            case NONE: {
                break;
            }
            case LDAPS: {
                ldapUrl.getExtensions().add(new LdapURL.Extension(false, X_ENCRYPTION, X_ENCRYPTION_LDAPS));
                break;
            }
            case START_TLS: {
                ldapUrl.getExtensions().add(new LdapURL.Extension(false, X_ENCRYPTION, X_ENCRYPTION_START_TLS));
            }
        }
    }

    public void mergeLdapUrlToParameters(LdapURL ldapUrl, ConnectionParameter parameter) {
        String name = ldapUrl.getExtensionValue(X_CONNECTION_NAME);
        if (StringUtils.isEmpty((String)name)) {
            name = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss").format(new Date());
        }
        parameter.setName(name);
        parameter.setHost(ldapUrl.getHost());
        parameter.setPort(ldapUrl.getPort());
        String encryption = ldapUrl.getExtensionValue(X_ENCRYPTION);
        if (StringUtils.isNotEmpty((String)encryption) && X_ENCRYPTION_LDAPS.equalsIgnoreCase(encryption)) {
            parameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.LDAPS);
        } else if (StringUtils.isNotEmpty((String)encryption) && X_ENCRYPTION_START_TLS.equalsIgnoreCase(encryption)) {
            parameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.START_TLS);
        } else {
            parameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.NONE);
        }
    }
}

