/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.widgets;

import org.apache.directory.studio.connection.ui.widgets.ConnectionConfiguration;
import org.apache.directory.studio.connection.ui.widgets.ViewFormWidget;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;

public class ConnectionWidget
extends ViewFormWidget {
    private ConnectionConfiguration configuration;
    private IActionBars actionBars;
    private Tree tree;
    private TreeViewer viewer;

    public ConnectionWidget(ConnectionConfiguration configuration, IActionBars actionBars) {
        this.configuration = configuration;
        this.actionBars = actionBars;
    }

    public void createWidget(Composite parent) {
        if (this.actionBars == null) {
            super.createWidget(parent);
        } else {
            this.createContent(parent);
        }
    }

    public IToolBarManager getToolBarManager() {
        if (this.actionBars == null) {
            return super.getToolBarManager();
        }
        return this.actionBars.getToolBarManager();
    }

    public IMenuManager getMenuManager() {
        if (this.actionBars == null) {
            return super.getMenuManager();
        }
        return this.actionBars.getMenuManager();
    }

    public IMenuManager getContextMenuManager() {
        if (this.actionBars == null) {
            return super.getContextMenuManager();
        }
        return this.configuration.getContextMenuManager(this.viewer);
    }

    protected Control createContent(Composite parent) {
        this.tree = new Tree(parent, 2818);
        GridData data = new GridData(1808);
        data.widthHint = 450;
        data.heightHint = 250;
        this.tree.setLayoutData((Object)data);
        this.viewer = new TreeViewer(this.tree);
        this.configuration.getSorter().connect(this.viewer);
        this.viewer.setContentProvider((IContentProvider)this.configuration.getContentProvider(this.viewer));
        this.viewer.setLabelProvider((IBaseLabelProvider)this.configuration.getLabelProvider(this.viewer));
        return this.tree;
    }

    public void setInput(Object input) {
        this.viewer.setInput(input);
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public void dispose() {
        if (this.viewer != null) {
            this.configuration.dispose();
            this.configuration = null;
            this.tree.dispose();
            this.tree = null;
            this.viewer = null;
        }
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }
}

