/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.widgets;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ConnectionLabelProvider
extends LabelProvider {
    public String getText(Object obj) {
        if (obj instanceof ConnectionFolder) {
            ConnectionFolder folder = (ConnectionFolder)obj;
            return folder.getName();
        }
        if (obj instanceof Connection) {
            Connection conn = (Connection)obj;
            if (conn.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.LDAPS) {
                return conn.getName() + " (LDAPS)";
            }
            if (conn.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.START_TLS) {
                return conn.getName() + " (StartTLS)";
            }
            return conn.getName();
        }
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    public Image getImage(Object obj) {
        if (obj instanceof ConnectionFolder) {
            return ConnectionUIPlugin.getDefault().getImage("resources/icons/connection_folder.gif");
        }
        if (obj instanceof Connection) {
            Connection conn = (Connection)obj;
            if (conn.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.LDAPS || conn.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.START_TLS) {
                return conn.getJNDIConnectionWrapper().isConnected() ? ConnectionUIPlugin.getDefault().getImage("resources/icons/connection_ssl_connected.gif") : ConnectionUIPlugin.getDefault().getImage("resources/icons/connection_ssl_disconnected.gif");
            }
            return conn.getJNDIConnectionWrapper().isConnected() ? ConnectionUIPlugin.getDefault().getImage("resources/icons/connection_connected.gif") : ConnectionUIPlugin.getDefault().getImage("resources/icons/connection_disconnected.gif");
        }
        return null;
    }
}

