/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.widgets;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.directory.studio.connection.core.StudioKeyStoreManager;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.connection.ui.dialogs.CertificateInfoDialog;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.ui.widgets.Messages;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CertificateListComposite
extends Composite {
    private StudioKeyStoreManager keyStoreManager;
    private Composite container;
    private TableViewer tableViewer;
    private Button viewButton;
    private Button addButton;
    private Button removeButton;

    public CertificateListComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.container = new Composite((Composite)this, 0);
        layout = new GridLayout(2, false);
        this.container.setLayout((Layout)layout);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTreeViewer();
        this.createButtons();
    }

    private void createTreeViewer() {
        this.tableViewer = new TableViewer(this.container, 2818);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 360;
        gd.heightHint = 10;
        this.tableViewer.getTable().setLayoutData((Object)gd);
        this.tableViewer.setContentProvider((IContentProvider)new KeyStoreContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new KeyStoreLabelProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CertificateListComposite.this.viewButton.setEnabled(!event.getSelection().isEmpty());
                CertificateListComposite.this.removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                X509Certificate certificate = (X509Certificate)selection.getFirstElement();
                new CertificateInfoDialog(CertificateListComposite.this.getShell(), new X509Certificate[]{certificate}).open();
            }
        });
    }

    private void createButtons() {
        Composite buttonContainer = BaseWidgetUtils.createColumnContainer(this.container, 1, 1);
        buttonContainer.setLayoutData((Object)new GridData(4, 4, false, false));
        this.viewButton = BaseWidgetUtils.createButton(buttonContainer, Messages.getString("CertificateListComposite.ViewButton"), 1);
        this.viewButton.setEnabled(false);
        this.viewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)CertificateListComposite.this.tableViewer.getSelection();
                X509Certificate certificate = (X509Certificate)selection.getFirstElement();
                new CertificateInfoDialog(CertificateListComposite.this.getShell(), new X509Certificate[]{certificate}).open();
            }
        });
        this.addButton = BaseWidgetUtils.createButton(buttonContainer, Messages.getString("CertificateListComposite.AddButton"), 1);
        this.addButton.setEnabled(false);
        this.removeButton = BaseWidgetUtils.createButton(buttonContainer, Messages.getString("CertificateListComposite.RemoveButton"), 1);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)CertificateListComposite.this.tableViewer.getSelection();
                for (X509Certificate certificate : selection) {
                    try {
                        CertificateListComposite.this.keyStoreManager.removeCertificate(certificate);
                    }
                    catch (CertificateException ce) {
                        throw new RuntimeException(ce);
                    }
                }
                CertificateListComposite.this.tableViewer.refresh();
            }
        });
    }

    public void setInput(StudioKeyStoreManager keyStoreManager) {
        this.keyStoreManager = keyStoreManager;
        this.tableViewer.setInput((Object)keyStoreManager);
    }

    class KeyStoreLabelProvider
    extends LabelProvider {
        KeyStoreLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof X509Certificate) {
                X509Certificate certificate = (X509Certificate)element;
                String certificateName = certificate.getSubjectX500Principal().getName();
                if (certificateName != null && !"".equals(certificateName)) {
                    return certificateName;
                }
                return Messages.getString("CertificateListComposite.UntitledCertificate");
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof X509Certificate) {
                return ConnectionUIPlugin.getDefault().getImage("resources/icons/certificate.gif");
            }
            return super.getImage(element);
        }
    }

    class KeyStoreContentProvider
    implements IStructuredContentProvider {
        KeyStoreContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof StudioKeyStoreManager) {
                StudioKeyStoreManager keyStoreManager = (StudioKeyStoreManager)inputElement;
                try {
                    return keyStoreManager.getCertificates();
                }
                catch (CertificateException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

