/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.dialogs;

import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.directory.studio.connection.core.ICertificateHandler;
import org.apache.directory.studio.connection.ui.dialogs.CertificateInfoDialog;
import org.apache.directory.studio.connection.ui.dialogs.Messages;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateTrustDialog
extends Dialog {
    private String title;
    private ICertificateHandler.TrustLevel trustLevel;
    private String host;
    private X509Certificate[] certificateChain;
    private List<ICertificateHandler.FailCause> failCauses;
    private Button trustNotButton;
    private Button trustSessionButton;
    private Button trustPermanentButton;

    public CertificateTrustDialog(Shell parentShell, String host, X509Certificate[] certificateChain, List<ICertificateHandler.FailCause> failCauses) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.title = Messages.getString("CertificateTrustDialog.CertificateTrust");
        this.host = host;
        this.certificateChain = certificateChain;
        this.failCauses = failCauses;
        this.trustLevel = null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 13, Messages.getString("CertificateTrustDialog.ViewCertificate"), false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 13) {
            new CertificateInfoDialog(this.getShell(), this.certificateChain).open();
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        gd.heightHint = this.convertHorizontalDLUsToPixels(150);
        composite.setLayoutData((Object)gd);
        BaseWidgetUtils.createWrappedLabel(composite, NLS.bind((String)Messages.getString("CertificateTrustDialog.InvalidCertificate"), (Object)this.host), 1);
        Composite failedCauseContainer = BaseWidgetUtils.createColumnContainer(composite, 1, 1);
        for (ICertificateHandler.FailCause failCause : this.failCauses) {
            switch (failCause) {
                case SelfSignedCertificate: {
                    BaseWidgetUtils.createWrappedLabel(failedCauseContainer, Messages.getString("CertificateTrustDialog.SelfSignedCertificate"), 1);
                    break;
                }
                case CertificateExpired: {
                    BaseWidgetUtils.createWrappedLabel(failedCauseContainer, Messages.getString("CertificateTrustDialog.CertificateExpired"), 1);
                    break;
                }
                case CertificateNotYetValid: {
                    BaseWidgetUtils.createWrappedLabel(failedCauseContainer, Messages.getString("CertificateTrustDialog.CertificateNotYetValid"), 1);
                    break;
                }
                case NoValidCertificationPath: {
                    BaseWidgetUtils.createWrappedLabel(failedCauseContainer, Messages.getString("CertificateTrustDialog.NoValidCertificationPath"), 1);
                    break;
                }
                case HostnameVerificationFailed: {
                    BaseWidgetUtils.createWrappedLabel(failedCauseContainer, Messages.getString("CertificateTrustDialog.HostnameVerificationFailed"), 1);
                }
            }
        }
        BaseWidgetUtils.createSpacer(composite, 1);
        BaseWidgetUtils.createSpacer(composite, 1);
        BaseWidgetUtils.createWrappedLabel(composite, NLS.bind((String)Messages.getString("CertificateTrustDialog.ChooseTrustLevel"), (Object)this.host), 1);
        this.trustNotButton = BaseWidgetUtils.createRadiobutton(composite, Messages.getString("CertificateTrustDialog.DoNotTrust"), 1);
        this.trustNotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateTrustDialog.this.trustLevel = ICertificateHandler.TrustLevel.Not;
            }
        });
        this.trustSessionButton = BaseWidgetUtils.createRadiobutton(composite, Messages.getString("CertificateTrustDialog.TrustForThisSession"), 1);
        this.trustSessionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateTrustDialog.this.trustLevel = ICertificateHandler.TrustLevel.Session;
            }
        });
        this.trustPermanentButton = BaseWidgetUtils.createRadiobutton(composite, Messages.getString("CertificateTrustDialog.AlwaysTrust"), 1);
        this.trustPermanentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateTrustDialog.this.trustLevel = ICertificateHandler.TrustLevel.Permanent;
            }
        });
        this.trustNotButton.setSelection(true);
        this.trustLevel = ICertificateHandler.TrustLevel.Not;
        return composite;
    }

    public ICertificateHandler.TrustLevel getTrustLevel() {
        return this.trustLevel;
    }
}

