/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.actions;

import org.apache.directory.studio.connection.core.jobs.CloseConnectionsRunnable;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionJob;
import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.connection.ui.actions.Messages;
import org.apache.directory.studio.connection.ui.actions.StudioAction;
import org.eclipse.jface.resource.ImageDescriptor;

public class CloseConnectionAction
extends StudioAction {
    public void run() {
        new StudioConnectionJob(new StudioRunnableWithProgress[]{new CloseConnectionsRunnable(this.getSelectedConnections())}).execute();
    }

    public String getText() {
        return this.getSelectedConnections().length > 1 ? Messages.getString("CloseConnectionAction.CloseConnections") : Messages.getString("CloseConnectionAction.CloseConnection");
    }

    public ImageDescriptor getImageDescriptor() {
        return ConnectionUIPlugin.getDefault().getImageDescriptor("resources/icons/connection_disconnect.gif");
    }

    public String getCommandId() {
        return null;
    }

    public boolean isEnabled() {
        boolean canClose = false;
        for (int i = 0; i < this.getSelectedConnections().length; ++i) {
            if (!this.getSelectedConnections()[i].getJNDIConnectionWrapper().isConnected()) continue;
            canClose = true;
            break;
        }
        return this.getSelectedConnections().length > 0 && canClose;
    }
}

