/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.IReferralHandler;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateAdapter;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateListener;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.connection.ui.dialogs.SelectReferralConnectionDialog;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionUIReferralHandler
extends ConnectionUpdateAdapter
implements IReferralHandler {
    private Map<String, Connection> referralUrlToReferralConnectionCache = new HashMap<String, Connection>();

    public ConnectionUIReferralHandler() {
        ConnectionEventRegistry.addConnectionUpdateListener((ConnectionUpdateListener)this, (EventRunner)ConnectionCorePlugin.getDefault().getEventRunner());
    }

    public void connectionClosed(Connection connection) {
        this.referralUrlToReferralConnectionCache.clear();
    }

    public Connection getReferralConnection(final List<LdapURL> referralUrls) {
        for (LdapURL url : referralUrls) {
            String normalizedUrl = Utils.getSimpleNormalizedUrl((LdapURL)url);
            if (!this.referralUrlToReferralConnectionCache.containsKey(normalizedUrl)) continue;
            Connection referralConnection = this.referralUrlToReferralConnectionCache.get(normalizedUrl);
            Connection[] connections = ConnectionCorePlugin.getDefault().getConnectionManager().getConnections();
            for (int i = 0; i < connections.length; ++i) {
                Connection connection = connections[i];
                if (referralConnection != connection) continue;
                return referralConnection;
            }
            this.referralUrlToReferralConnectionCache.remove(normalizedUrl);
        }
        final Connection[] referralConnections = new Connection[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                SelectReferralConnectionDialog dialog = new SelectReferralConnectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), referralUrls);
                if (dialog.open() == 0) {
                    Connection connection;
                    referralConnections[0] = connection = dialog.getReferralConnection();
                }
            }
        });
        if (referralConnections[0] != null) {
            for (LdapURL url : referralUrls) {
                String normalizedUrl = Utils.getSimpleNormalizedUrl((LdapURL)url);
                this.referralUrlToReferralConnectionCache.put(normalizedUrl, referralConnections[0]);
            }
        }
        return referralConnections[0];
    }
}

