/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio;

import org.apache.directory.studio.Messages;
import org.apache.directory.studio.actions.ManageConfigurationAction;
import org.apache.directory.studio.actions.OpenFileAction;
import org.apache.directory.studio.actions.ReportABugAction;
import org.apache.directory.studio.actions.UpdateAction;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.NewWizardDropDownAction;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private static final String OS_MACOSX = "macosx";
    private OpenFileAction openFileAction;
    private ActionFactory.IWorkbenchAction closeAction;
    private ActionFactory.IWorkbenchAction closeAllAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAsAction;
    private ActionFactory.IWorkbenchAction saveAllAction;
    private ActionFactory.IWorkbenchAction printAction;
    private ActionFactory.IWorkbenchAction refreshAction;
    private ActionFactory.IWorkbenchAction renameAction;
    private ActionFactory.IWorkbenchAction moveAction;
    private ActionFactory.IWorkbenchAction exitAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private ActionFactory.IWorkbenchAction preferencesAction;
    private ActionFactory.IWorkbenchAction helpAction;
    private ActionFactory.IWorkbenchAction dynamicHelpAction;
    private UpdateAction updateAction;
    private ManageConfigurationAction manageConfigurationAction;
    private ActionFactory.IWorkbenchAction newAction;
    private ActionFactory.IWorkbenchAction newDropDownAction;
    private ActionFactory.IWorkbenchAction importAction;
    private ActionFactory.IWorkbenchAction exportAction;
    private ActionFactory.IWorkbenchAction propertiesAction;
    private ActionFactory.IWorkbenchAction closePerspectiveAction;
    private ActionFactory.IWorkbenchAction closeAllPerspectivesAction;
    private ActionFactory.IWorkbenchAction undoAction;
    private ActionFactory.IWorkbenchAction redoAction;
    private ActionFactory.IWorkbenchAction cutAction;
    private ActionFactory.IWorkbenchAction copyAction;
    private ActionFactory.IWorkbenchAction pasteAction;
    private ActionFactory.IWorkbenchAction deleteAction;
    private ActionFactory.IWorkbenchAction selectAllAction;
    private ActionFactory.IWorkbenchAction findAction;
    private IContributionItem perspectivesList;
    private IContributionItem viewsList;
    private IContributionItem reopenEditorsList;
    private ReportABugAction reportABug;
    private ActionFactory.IWorkbenchAction backwardHistoryAction;
    private ActionFactory.IWorkbenchAction forwardHistoryAction;
    private ActionFactory.IWorkbenchAction nextAction;
    private ActionFactory.IWorkbenchAction previousAction;
    private ActionFactory.IWorkbenchAction introAction;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.newAction = ActionFactory.NEW.create(window);
        this.register((IAction)this.newAction);
        this.newAction.setText(Messages.getString("ApplicationActionBarAdvisor.new"));
        this.newDropDownAction = new NewWizardDropDownAction(window);
        this.openFileAction = new OpenFileAction(window);
        this.register((IAction)this.openFileAction);
        this.closeAction = ActionFactory.CLOSE.create(window);
        this.register((IAction)this.closeAction);
        this.closeAllAction = ActionFactory.CLOSE_ALL.create(window);
        this.register((IAction)this.closeAllAction);
        this.saveAction = ActionFactory.SAVE.create(window);
        this.register((IAction)this.saveAction);
        this.saveAsAction = ActionFactory.SAVE_AS.create(window);
        this.register((IAction)this.saveAsAction);
        this.saveAllAction = ActionFactory.SAVE_ALL.create(window);
        this.register((IAction)this.saveAllAction);
        this.printAction = ActionFactory.PRINT.create(window);
        this.register((IAction)this.printAction);
        this.moveAction = ActionFactory.MOVE.create(window);
        this.register((IAction)this.moveAction);
        this.renameAction = ActionFactory.RENAME.create(window);
        this.register((IAction)this.renameAction);
        this.refreshAction = ActionFactory.REFRESH.create(window);
        this.register((IAction)this.refreshAction);
        this.importAction = ActionFactory.IMPORT.create(window);
        this.register((IAction)this.importAction);
        this.exportAction = ActionFactory.EXPORT.create(window);
        this.register((IAction)this.exportAction);
        this.propertiesAction = ActionFactory.PROPERTIES.create(window);
        this.register((IAction)this.propertiesAction);
        this.exitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.exitAction);
        this.undoAction = ActionFactory.UNDO.create(window);
        this.register((IAction)this.undoAction);
        this.redoAction = ActionFactory.REDO.create(window);
        this.register((IAction)this.redoAction);
        this.cutAction = ActionFactory.CUT.create(window);
        this.register((IAction)this.cutAction);
        this.copyAction = ActionFactory.COPY.create(window);
        this.register((IAction)this.copyAction);
        this.pasteAction = ActionFactory.PASTE.create(window);
        this.register((IAction)this.pasteAction);
        this.deleteAction = ActionFactory.DELETE.create(window);
        this.register((IAction)this.deleteAction);
        this.selectAllAction = ActionFactory.SELECT_ALL.create(window);
        this.register((IAction)this.selectAllAction);
        this.findAction = ActionFactory.FIND.create(window);
        this.register((IAction)this.findAction);
        this.closePerspectiveAction = ActionFactory.CLOSE_PERSPECTIVE.create(window);
        this.register((IAction)this.closePerspectiveAction);
        this.closeAllPerspectivesAction = ActionFactory.CLOSE_ALL_PERSPECTIVES.create(window);
        this.register((IAction)this.closeAllPerspectivesAction);
        this.aboutAction = ActionFactory.ABOUT.create(window);
        this.aboutAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.apache.directory.studio.rcp", (String)"resources/icons/about.png"));
        this.register((IAction)this.aboutAction);
        this.preferencesAction = ActionFactory.PREFERENCES.create(window);
        this.preferencesAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.apache.directory.studio.rcp", (String)"resources/icons/preferences.png"));
        this.register((IAction)this.preferencesAction);
        this.updateAction = new UpdateAction(window);
        this.updateAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.apache.directory.studio.rcp", (String)"resources/icons/search-updates.png"));
        this.register(this.updateAction);
        this.manageConfigurationAction = new ManageConfigurationAction(window);
        this.manageConfigurationAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.apache.directory.studio.rcp", (String)"resources/icons/manage-configuration.png"));
        this.register(this.manageConfigurationAction);
        this.helpAction = ActionFactory.HELP_CONTENTS.create(window);
        this.register((IAction)this.helpAction);
        this.dynamicHelpAction = ActionFactory.DYNAMIC_HELP.create(window);
        this.register((IAction)this.dynamicHelpAction);
        this.viewsList = ContributionItemFactory.VIEWS_SHORTLIST.create(window);
        this.perspectivesList = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(window);
        this.reopenEditorsList = ContributionItemFactory.REOPEN_EDITORS.create(window);
        this.reportABug = new ReportABugAction(window);
        this.reportABug.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.apache.directory.studio.rcp", (String)"resources/icons/bug-report.png"));
        this.register((IAction)this.reportABug);
        this.forwardHistoryAction = ActionFactory.FORWARD_HISTORY.create(window);
        this.register((IAction)this.forwardHistoryAction);
        this.backwardHistoryAction = ActionFactory.BACKWARD_HISTORY.create(window);
        this.register((IAction)this.backwardHistoryAction);
        this.nextAction = ActionFactory.NEXT.create(window);
        this.register((IAction)this.nextAction);
        this.previousAction = ActionFactory.PREVIOUS.create(window);
        this.register((IAction)this.previousAction);
        this.introAction = ActionFactory.INTRO.create(window);
        this.introAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.apache.directory.studio.rcp", (String)"resources/icons/intro.gif"));
        this.register((IAction)this.introAction);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        String os = Platform.getOS();
        MenuManager fileMenu = new MenuManager(Messages.getString("ApplicationActionBarAdvisor.file"), "file");
        MenuManager editMenu = new MenuManager(Messages.getString("ApplicationActionBarAdvisor.edit"), "edit");
        MenuManager navigateMenu = new MenuManager(Messages.getString("ApplicationActionBarAdvisor.navigate"), "navigate");
        MenuManager windowMenu = new MenuManager(Messages.getString("ApplicationActionBarAdvisor.windows"), "window");
        MenuManager helpMenu = new MenuManager(Messages.getString("ApplicationActionBarAdvisor.help"), "help");
        MenuManager hiddenMenu = new MenuManager("Hidden", "org.apache.directory.studio.rcp.hidden");
        hiddenMenu.setVisible(false);
        menuBar.add((IContributionItem)fileMenu);
        menuBar.add((IContributionItem)editMenu);
        menuBar.add((IContributionItem)navigateMenu);
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        menuBar.add((IContributionItem)windowMenu);
        menuBar.add((IContributionItem)helpMenu);
        menuBar.add((IContributionItem)hiddenMenu);
        fileMenu.add((IAction)this.newAction);
        fileMenu.add((IContributionItem)new GroupMarker("new.ext"));
        fileMenu.add((IAction)this.openFileAction);
        fileMenu.add((IContributionItem)new GroupMarker("open.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.closeAction);
        fileMenu.add((IAction)this.closeAllAction);
        fileMenu.add((IContributionItem)new GroupMarker("close.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.saveAction);
        fileMenu.add((IAction)this.saveAsAction);
        fileMenu.add((IAction)this.saveAllAction);
        fileMenu.add((IContributionItem)new GroupMarker("save.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.refreshAction);
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.printAction);
        fileMenu.add((IContributionItem)new GroupMarker("print.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.importAction);
        fileMenu.add((IAction)this.exportAction);
        fileMenu.add((IContributionItem)new GroupMarker("import.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.propertiesAction);
        fileMenu.add(this.reopenEditorsList);
        fileMenu.add((IContributionItem)new GroupMarker("mru"));
        if (OS_MACOSX.equalsIgnoreCase(os)) {
            hiddenMenu.add((IAction)this.exitAction);
        } else {
            fileMenu.add((IContributionItem)new Separator());
            fileMenu.add((IAction)this.exitAction);
        }
        editMenu.add((IAction)this.undoAction);
        editMenu.add((IAction)this.redoAction);
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IAction)this.cutAction);
        editMenu.add((IAction)this.copyAction);
        editMenu.add((IAction)this.pasteAction);
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IAction)this.deleteAction);
        editMenu.add((IAction)this.selectAllAction);
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IAction)this.moveAction);
        editMenu.add((IAction)this.renameAction);
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IAction)this.findAction);
        navigateMenu.add((IAction)this.nextAction);
        navigateMenu.add((IAction)this.previousAction);
        navigateMenu.add((IContributionItem)new Separator("additions"));
        navigateMenu.add((IContributionItem)new GroupMarker("navEnd"));
        navigateMenu.add((IContributionItem)new Separator());
        navigateMenu.add((IAction)this.backwardHistoryAction);
        navigateMenu.add((IAction)this.forwardHistoryAction);
        MenuManager perspectiveMenu = new MenuManager(Messages.getString("ApplicationActionBarAdvisor.openPerspective"), "openPerspective");
        perspectiveMenu.add(this.perspectivesList);
        windowMenu.add((IContributionItem)perspectiveMenu);
        MenuManager viewMenu = new MenuManager(Messages.getString("ApplicationActionBarAdvisor.showView"));
        viewMenu.add(this.viewsList);
        windowMenu.add((IContributionItem)viewMenu);
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)this.closePerspectiveAction);
        windowMenu.add((IAction)this.closeAllPerspectivesAction);
        if (OS_MACOSX.equalsIgnoreCase(os)) {
            hiddenMenu.add((IAction)this.preferencesAction);
        } else {
            windowMenu.add((IContributionItem)new Separator());
            windowMenu.add((IAction)this.preferencesAction);
        }
        helpMenu.add((IAction)this.introAction);
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IAction)this.helpAction);
        helpMenu.add((IAction)this.dynamicHelpAction);
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IAction)this.reportABug);
        helpMenu.add((IContributionItem)new Separator());
        MenuManager softwareUpdates = new MenuManager(Messages.getString("ApplicationActionBarAdvisor.Software_Updates"), "softwareUpdates");
        softwareUpdates.add((IAction)this.updateAction);
        softwareUpdates.add((IAction)this.manageConfigurationAction);
        helpMenu.add((IContributionItem)softwareUpdates);
        if (OS_MACOSX.equalsIgnoreCase(os)) {
            hiddenMenu.add((IAction)this.aboutAction);
        } else {
            helpMenu.add((IContributionItem)new Separator());
            helpMenu.add((IAction)this.aboutAction);
        }
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        ToolBarManager toolbar = new ToolBarManager(0x820000);
        toolbar.add((IAction)this.newDropDownAction);
        toolbar.add((IAction)this.saveAction);
        toolbar.add((IAction)this.printAction);
        toolbar.add((IAction)this.preferencesAction);
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar, "org.apache.directory.studio.rcp.toolbar"));
        coolBar.add((IContributionItem)new GroupMarker("additions"));
        ToolBarManager navToolBar = new ToolBarManager(0x820000);
        navToolBar.add((IContributionItem)new Separator("history.group"));
        navToolBar.add((IAction)this.backwardHistoryAction);
        navToolBar.add((IAction)this.forwardHistoryAction);
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)navToolBar, "org.eclipse.ui.workbench.navigate"));
    }
}

